;----------------------------------------------------------------------------
; Gameboy Color
; Mednafen 0.9.15
; by BBB
; 1.1
;
; Notes:
; Below are some basic params you can change, there are many other params
; located in the mednafen documentation that you can add if needed.
;
; Some people experience screen flickering and mednafen will not stay in 
; fullscreen, you can changed vDriver below to -vdriver sdl and it will
; possibly fix the issue.
;
; There is no error checking if mednafen fails, so if you try to launch
; your game and nothing happens, then check the stdout.txt in your mednafen
; installation directory to see what went wrong.
;
; To remap your keys, start a game then press alt + shift + 1 to enter
; the key configuration.  Also see mednafen.cfg to change other keys such
; as the exit key.
;
;----------------------------------------------------------------------------

;Params
fullScreen := "-fs 1" ; 0 or 1
stretchFullscreen := "-gb.stretch 1" ; 0 or 1
vDriver := "-vdriver opengl" ; opengl or sdl
xRes := "-gb.xres 800"
yRes := "-gb.yres 600"
                   
params = %fullScreen% %stretchFullscreen% %vDriver% %xRes% %yRes% 

Run, "%EmuPath%%Executable%" %params% "%romPath%%romName%%romExtension%"

Process, WaitClose, %Executable%
     
ExitApp
           
CloseProcess:
return